% rbf_definitionMatern
%
% Defines RBF to be used from a long list of possibilities

function rbf_definitionMatern

global rbf Lrbf

%%% Matern functions
rbf = @(epsilon,r,s,beta) matern(epsilon,r,s,beta);

% Laplacian
Lrbf = @(epsilon,r,s,beta) Lmatern(epsilon,r,s,beta);

%%% Fourier transform of Matern functions
%rbf = @(epsilon,r,s,beta) epsilon^s*(1+(r/epsilon).^2).^(-beta);


function rbf = matern(epsilon,r,s,beta)
scale = gamma(beta-s/2)*2^(-s/2)/gamma(beta);
rbf = scale*ones(size(r));
nz = find(r~=0);
rbf(nz) = 1/(2^(beta-1)*gamma(beta))*besselk(beta-s/2,epsilon*r(nz)).*(epsilon*r(nz)).^(beta-s/2);


function Lrbf = Lmatern(epsilon,r,s,beta)
scale = -epsilon^2*gamma(beta-s/2-1) / (2^(s/2)*gamma(beta));                  
Lrbf = scale*ones(size(r));
nz = find(r~=0);
Lrbf(nz) = epsilon^2/(2^(beta-1)*gamma(beta))*(epsilon*r(nz)).^(beta-s/2-2) .* ...
           ( ( (epsilon*r(nz)).^2 + 4*(beta-s/2)^2 ) .* besselk(beta-s/2,epsilon*r(nz)) ...
             - 2*(beta-s/2)*(epsilon*r(nz)) .* besselk(beta-s/2+1,epsilon*r(nz)) );
