% rbf_definition
%
% Defines RBF to be used from a long list of possibilities

function rbf_definition 

global rbf dxrbf dyrbf dxxrbf dxyrbf dyyrbf Lrbf L2rbf 

%%% GLOBAL, CPD0
rbf = @(epsilon,r) exp(-(epsilon*r).^2);     % Gaussian RBF
%rbf = @(epsilon,r) 1./sqrt(1+(epsilon*r).^2);    % IMQ RBF
%rbf = @(epsilon,r) 1./(1+(epsilon*r).^2).^2;   % generalized IMQ
%rbf = @(epsilon,r) 1./(1+(epsilon*r).^2);    % IQ RBF
%rbf = @(epsilon,r) exp(-epsilon*r);    % basic Matern
%rbf = @(epsilon,r) exp(-epsilon*r).*(1+epsilon*r);    % Matern linear
%rbf = @(epsilon,r) exp(-epsilon*r).*(3+3*epsilon*r+(epsilon*r).^2);   % Matern quadratic
%rbf = @(epsilon,r) exp(-epsilon*r).*(15+15*epsilon*r+6*(epsilon*r).^2+(epsilon*r).^3);    % Matern cubic
%%% GLOBAL, CPD1
%rbf = @(epsilon,r) epsilon*r;     % linear
%rbf = @(epsilon,r) sqrt(1+(epsilon*r).^2);   % MQ RBF
%%% GLOBAL, CPD2
%rbf = @(epsilon,r) (1+(epsilon*r).^2).^(3/2);   % generalized MQ
%rbf = @(epsilon,r) (epsilon*r).^3;   % cubic
%rbf = @tps;   % TPS (defined in separate function tps.m, in order to treat singularity at 0)
%%% GLOBAL, CPD3
%rbf = @(epsilon,r) (1+(epsilon*r).^2).^(5/2);   % generalized MQ
%rbf = @(epsilon,r) (epsilon*r).^5;   % quintic
%%% GLOBAL, CPD4
%rbf = @(epsilon,r) (epsilon*r).^7;   % septic
%%% GLOBAL oscillatory (CPD0)
%rbf = @(epsilon,r) exp(-(epsilon*r).^2).*(2-(epsilon*r).^2);     % Gaussian linear Laguerre
%rbf = @(epsilon,r) exp(-(epsilon*r).^2).*(3-3*(epsilon*r).^2+0.5*(epsilon*r).^4)/3;     % Gaussian quadratic Laguerre
%rbf = @(epsilon,r) (1/4)*(4-2*(epsilon*r).^2)./(1+(epsilon*r).^2).^4;   % linear generalized IMQ
%rbf = @(epsilon,r) (1/9)*(9-18*(epsilon*r).^2+3*(epsilon*r).^4)./(1+(epsilon*r).^2).^6;   % quadratic generalized IMQ
%rbf = @(epsilon,r) sinc(epsilon*r);    % d=1
%rbf = @(epsilon,r) besselj(0,epsilon*r);    % d=2
%%% CSRBF (CPD0) all in the form (1-e*r) -> r for use with SPARSE code
%rbf = @(epsilon,r) r.^2;    % Wendland C0
%rbf = @(epsilon,r) r.^4.*(5*spones(r)-4*r);    % Wendland C2
%rbf = @(epsilon,r) r.^6.*(35*r.^2-88*r+56*spones(r));    % Wendland C4
%rbf = @(epsilon,r) r.^8.*(66*spones(r)-154*r+121*r.^2-32*r.^3);    % Wendland C6
%rbf = @(epsilon,r) r.^4.*(70*spones(r)-84*r+35*r.^2-5*r.^3);    % Wu(3,3) C0, SPD(R7) 
%rbf = @(epsilon,r) r.^5.*(126*spones(r)-231*r+153*r.^2-45*r.^3+5*r.^4);    % Wu(2,3) C2, SPD(R5) 
%rbf = @(epsilon,r) r.^6.*(231*spones(r)-561*r+528*r.^2-242*r.^3+55*r.^4-5*r.^5);    % Wu(1,3) C4, SPD(R3) 
%rbf = @(epsilon,r) r.^7.*(429*spones(r)-1287*r+1573*r.^2-1001*r.^3+351*r.^4-65*r.^5+5*r.^6);    % Wu(0,3) C6, SPD(R1) 
%rbf = @buhmann_sparse;   % Buhmann C2
%rbf = @(epsilon,r) -r.^(7/2).*(99*spones(r)-242*r+135*r.^2)/8;    % Gneiting (2,7)
%rbf = @(epsilon,r) -r.^5.*(21*spones(r)-49*r+27*r.^2);    % Gneiting (2,10)
%rbf = @(epsilon,r) -r.^(15/2).*(323/8*spones(r)-722*r+391*r^2)/8;    % Gneiting (2,15)
%rbf = @(epsilon,r) -r.^12.*(91*spones(r)-196*r+104*r.^2);    % Gneiting (2,24)
%rbf = @(epsilon,r) -r.^4.*(10*spones(r)-26*r+15*r.^2);    % Gneiting C2, R3
%rbf = @(epsilon,r) -r.^6.*(168*spones(r)-552*r+573*r.^2-192*r.^3);    % Gneiting C4, R3
%rbf = @(epsilon,r) -r.^8.*(3960*spones(r)-15840*r+23100*r.^2-14700*r.^3+3465*r.^4);    % Gneiting C6, R3
%rbf = @(epsilon,r) spones(r)+r/2;   % Euclid s=1
%rbf = @(epsilon,r) 1/2*(4*acos(1/2*spones(r)-1/2*r)-sqrt(3*spones(r)+2*r-r^2)+sqrt(3*spones(r)+2*r-r.^2).*r)/pi;   % Euclid s=2
%rbf = @(epsilon,r) 1/32*((16*pi-3)*spones(r)+r+3*r.^2+16*r*pi-r.^3)/pi;   % Euclid s=3
%rbf = @(epsilon,r) 1/32*(64*acos((spones(r)-r)/2)-19*sqrt(3*spones(r)+2*r-r.^2)+17*sqrt(3*spones(r)+2*r-r.^2).*r+3*sqrt(3*spones(r)+2*r-r.^2).*r.^2-sqrt(3*spones(r)+2*r-r.^2).*r.^3)/pi;   % Euclid s=4
%rbf = @(epsilon,r) 1/64*((32*pi^2-9-6*pi)*spones(r)+3*r+9*r.^2+2*r*pi+6*pi*r.^2+32*r*pi^2-3*r.^3-2*pi*r.^3)/pi^2);   % Euclid s=5
%rbf = @(epsilon,r) (7/pi)*r.^4.*(5*spones(r)-4*r);    % Wendland C2 generating function, d=0
%rbf = @(epsilon,r) (7/pi)*r.^4.*(5*spones(r)-4*r).*(-1476*spones(r)+3960*r-1980*r.^2)/229;    % Wendland C2 generating function, d=1
%%% CSRBF (CPD0) for use with DENSE code
%rbf = @(epsilon,r) max(1-epsilon*r,0).^2;    % Wendland C0
%rbf = @(epsilon,r) max(1-epsilon*r,0).^4.*(4*epsilon*r+1);    % Wendland C2
%rbf = @(epsilon,r) max(1-epsilon*r,0).^6.*(35*(epsilon*r).^2+18*epsilon*r+3);    % Wendland C4
%rbf = @(epsilon,r) max(1-epsilon*r,0).^8.*(32*(epsilon*r).^3+25*(epsilon*r).^2+8*epsilon*r+1);    % Wendland C6
%rbf = @(epsilon,r) max(1-epsilon*r,0).^4.*(5*(epsilon*r).^3+20*(epsilon*r).^2+29*epsilon*r+16);    % Wu(3,3) C0, SPD(R7) 
%rbf = @(epsilon,r) max(1-epsilon*r,0).^5.*(5*(epsilon*r).^4+25*(epsilon*r).^3+48*(epsilon*r).^2+40*epsilon*r+8);    % Wu(2,3) C2, SPD(R5) 
%rbf = @(epsilon,r) max(1-epsilon*r,0).^6.*(5*(epsilon*r).^5+30*(epsilon*r).^4+72*(epsilon*r).^3+82*(epsilon*r).^2+36*epsilon*r+6);    % Wu(1,3) C4, SPD(R3) 
%rbf = @(epsilon,r) max(1-epsilon*r,0).^7.*(5*(epsilon*r).^6+35*(epsilon*r).^5+101*(epsilon*r).^4+147*(epsilon*r).^3+101*(epsilon*r).^2+35*epsilon*r+5);    % Wu(0,3) C6, SPD(R1) 
%rbf = @buhmann;   % Buhmann C2
%rbf = @(epsilon,r) max(1-epsilon*r,0).^(7/2).*(1+7/2*epsilon*r-135/8*(epsilon*r).^2);    % Gneiting (2,7)
%rbf = @(epsilon,r) max(1-epsilon*r,0).^5.*(1+5*epsilon*r-27*(epsilon*r).^2);    % Gneiting (2,10)
%rbf = @(epsilon,r) max(1-epsilon*r,0).^(15/2).*(1+15/2*epsilon*r-391/8*(epsilon*r).^2);    % Gneiting (2,15)
%rbf = @(epsilon,r) max(1-epsilon*r,0).^12.*(1+12*epsilon*r-104*(epsilon*r).^2);    % Gneiting (2,24)
%rbf = @(epsilon,r) max(1-epsilon*r,0).^4.*(1+4*epsilon*r-15*(epsilon*r).^2);    % Gneiting C2, R3
%rbf = @(epsilon,r) max(1-epsilon*r,0).^6.*(3+18*epsilon*r+3*(epsilon*r).^2-192*(epsilon*r).^3);    % Gneiting C4, R3
%rbf = @(epsilon,r) max(1-epsilon*r,0).^8.*(15+120*epsilon*r+210*(epsilon*r).^2-840*(epsilon*r).^3-3465*(epsilon*r).^4);    % Gneiting C6, R3
%rbf = @(epsilon,r) max(1-epsilon*r/2,0);   % Euclid s=1
%rbf = @(epsilon,r) 1/(2*pi)*(4*acos(epsilon*r/2)-epsilon*r.*sqrt(4-(epsilon*r).^2));   % Euclid s=2
%rbf = @(epsilon,r) 1-1/(32*pi)*((4 + 16*pi)*epsilon*r - (epsilon*r).^3);   % Euclid s=3
%rbf = @(epsilon,r) 2/pi*acos(epsilon*r/2)-(1/(32*pi))*sqrt(4-(epsilon*r).^2).*(20*epsilon*r-(epsilon*r).^3);   % Euclid s=4
%rbf = @(epsilon,r) 1 - 1/(64*pi^2)*((12+8*pi+32*pi^2)*epsilon*r-(3+2*pi)*(epsilon*r).^3);   % Euclid s=5

% Derivatives of RBFs (for Hermite and Collocation)
% Dx
%dxrbf = @(epsilon,r,dx) -2*dx*epsilon^2.*exp(-(epsilon*r).^2);   % Gaussian
%dxrbf = @(epsilon,r,dx) -dx*epsilon^2./(1+(epsilon*r).^2).^(3/2);   % IMQ
%dxrbf = @(epsilon,r,dx) -dx*epsilon^2.*exp(-epsilon*r).*(1+epsilon*r);    % Matern quadratic
%dxrbf = @(epsilon,r,dx) -dx*epsilon^2.*(3+3*epsilon*r+(epsilon*r).^2).*exp(-epsilon*r);   % Matern cubic
%dxrbf = @(epsilon,r,dx) dx*epsilon^2./sqrt(1+(epsilon*r).^2);   % MQ
%dxrbf = @(epsilon,r,dx) 5*dx*epsilon^2.*(1+(epsilon*r).^2)^(3/2);   % generalized MQ
%dxrbf = @(epsilon,r,dx) 5*dx*epsilon^2.*(epsilon*r).^3;   % quintic
%dxrbf = @(epsilon,r,dx) 2*dx*epsilon^2.*exp(-(epsilon*r).^2).*((epsilon*r).^2-3);   % linear Laguerre-Gaussian
dxrbf = @(epsilon,r,dx) -56*dx*epsilon^2.*max(1-epsilon*r,0).^5.*(5*epsilon*r+1);   % Wendland C4
%dxrbf = @(epsilon,r,dx) -22*dx*epsilon^2.*max(1-epsilon*r,0).^7.*(16*(epsilon*r).^2+7*epsilon*r+1);   % Wendland C6
% Dy
%dyrbf = @(epsilon,r,dy) -2*dy*epsilon^2.*exp(-(epsilon*r).^2);   % Gaussian
%dyrbf = @(epsilon,r,dy) -dy*epsilon^2./(1+(epsilon*r).^2).^(3/2);   % IMQ
%dyrbf = @(epsilon,r,dy) -dy*epsilon^2.*exp(-epsilon*r).*(1+epsilon*r);    % Matern quadratic
%dyrbf = @(epsilon,r,dy) -dy*epsilon^2.*(3+3*epsilon*r+(epsilon*r).^2).*exp(-epsilon*r);   % Matern cubic
%dyrbf = @(epsilon,r,dy) dy*epsilon^2./sqrt(1+(epsilon*r).^2);   % MQ
%dyrbf = @(epsilon,r,dy) 5*dy*epsilon^2.*(1+(epsilon*r).^2)^(3/2);   % generalized MQ
%dyrbf = @(epsilon,r,dy) 5*dy*epsilon^2.*(epsilon*r).^3;   % quintic
%dyrbf = @(epsilon,r,dy) 2*dy*epsilon^2.*exp(-(epsilon*r).^2).*((epsilon*r).^2-3);   % linear Laguerre-Gaussian
dyrbf = @(epsilon,r,dy) -56*dy*epsilon^2.*max(1-epsilon*r,0).^5.*(5*epsilon*r+1);   % Wendland C4
%dyrbf = @(epsilon,r,dy) -22*dy*epsilon^2.*max(1-epsilon*r,0).^7.*(16*(epsilon*r).^2+7*epsilon*r+1);   % Wendland C6
% Dxx
%dxxrbf = @(epsilon,r,dx) 2*epsilon^2*(2*(epsilon*dx).^2-1).*exp(-(epsilon*r).^2);   % Gaussian
%dxxrbf = @(epsilon,r,dx) epsilon^2*(3*(epsilon*dx).^2-1-(epsilon*r).^2)./(1+(epsilon*r).^2).^(5/2);   % IMQ
%dxxrbf = @(epsilon,r,dx) epsilon^2*((epsilon*dx).^2-epsilon*r-1).*exp(-epsilon*r);    % Matern quadratic
%dxxrbf = @(epsilon,r,dx) epsilon^2*(epsilon^3*r.*dx.^2+epsilon^2*(dx.^2-r.^2)-3*epsilon*r-3).*exp(-epsilon*r);   % Matern cubic
%dxxrbf = @(epsilon,r,dx) epsilon^2*(1+(epsilon*r).^2-(epsilon*dx).^2)./(1+(epsilon*r).^2).^(3/2);   % MQ
%dxxrbf = @(epsilon,r,dx) 5*epsilon^2*(3*(epsilon*dx).^2+1+(epsilon*r).^2).*sqrt(1+(epsilon*r).^2);   % generalized MQ
%dxxrbf = @(epsilon,r,dx) 5*epsilon^2*(3*(epsilon*dx).^2.*(epsilon*r)+(epsilon*r).^3);   % quintic
%dxxrbf = @(epsilon,r,dx) -2*epsilon^2*exp(-(epsilon*r).^2).*(2*epsilon^4*dx.^2.*r.^2-(epsilon*r).^2-8*(epsilon*dx).^2+3);   % linear Laguerre-Gaussian
dxxrbf = @(epsilon,r,dx) 56*epsilon^2*(5*(epsilon*r).^2+30*(epsilon*dx).^2-4*epsilon*r-1).*max(1-epsilon*r,0).^4;   % Wendland C4
%dxxrbf = @(epsilon,r,dx) 22*epsilon^2*max(1-epsilon*r,0).^6.*(16*epsilon^3*(r.^2+9*dx.^2).*r+3*epsilon^2*(8*dx.^2-3*r.^2)-6*epsilon*r-1);   % Wendland C6
% Dxy
%dxyrbf = @(epsilon,r,dx,dy) 4*epsilon^4*dx.*dy.*exp(-(epsilon*r).^2);   % Gaussian
%dxyrbf = @(epsilon,r,dx,dy) 3*epsilon^4*dx.*dy./(1+(epsilon*r).^2).^(5/2);   % IMQ
%dxyrbf = @(epsilon,r,dx,dy) epsilon^4*dx.*dy.*exp(-epsilon*r);   Matern quadratic
%dxyrbf = @(epsilon,r,dx,dy) epsilon^4*dx.*dy.*(epsilon*r+1).*exp(-epsilon*r);   %Matern cubic
%dxyrbf = @(epsilon,r,dx,dy) -epsilon^4*dx.*dy./(1+(epsilon*r).^2).^(3/2);   % MQ
%dxyrbf = @(epsilon,r,dx,dy) 15*epsilon^4*dx.*dy.*sqrt(1+(epsilon*r).^2);   %generalized MQ
%dxyrbf = @(epsilon,r,dx,dy) 15*epsilon^5*dx.*dy.*r;   % quintic
%dxyrbf = @(epsilon,r,dx,dy) -4*epsilon^4*dx.*dy.*exp(-(epsilon*r).^2).*((epsilon*r).^2-4);   % linear Laguerre-Gaussian
dxyrbf = @(epsilon,r,dx,dy) 1680*epsilon^4*dx.*dy.*max(1-epsilon*r,0).^4;   % Wendland C4
%dxyrbf = @(epsilon,r,dx,dy) 528*epsilon^4*dx.*dy.*(max(1-epsilon*r,0).^6.*(6*epsilon*r+1);   % Wendland C6
% Dyy
%dyyrbf = @(epsilon,r,dy) 2*epsilon^2*(2*(epsilon*dy).^2-1).*exp(-(epsilon*r).^2);   % Gaussian
%dyyrbf = @(epsilon,r,dy) epsilon^2*(3*(epsilon*dy).^2-1-(epsilon*r).^2)./(1+(epsilon*r).^2).^(5/2);   % IMQ
%dyyrbf = @(epsilon,r,dy) epsilon^2*((epsilon*dy).^2-epsilon*r-1).*exp(-epsilon*r);    % Matern quadratic
%dyyrbf = @(epsilon,r,dy) epsilon^2*(epsilon^3*r.*dy.^2+epsilon^2*(dy.^2-r.^2)-3*epsilon*r-3).*exp(-epsilon*r);   % Matern cubic
%dyyrbf = @(epsilon,r,dy) epsilon^2*(1+(epsilon*r).^2-(epsilon*dy).^2)./(1+(epsilon*r).^2).^(3/2);   % MQ
%dyyrbf = @(epsilon,r,dy) 5*epsilon^2*(3*(epsilon*dy).^2+1+(epsilon*r).^2).*sqrt(1+(epsilon*r).^2);   % generalized MQ
%dyyrbf = @(epsilon,r,dy) 5*epsilon^2*(3*(epsilon*dy).^2.*(epsilon*r)+(epsilon*r).^3);   % quintic
%dyyrbf = @(epsilon,r,dy) -2*epsilon^2*exp(-(epsilon*r).^2).*(2*epsilon^4*dy.^2.*r.^2-(epsilon*r).^2-8*(epsilon*dy).^2+3);   % linear Laguerre-Gaussian
dyyrbf = @(epsilon,r,dy) 56*epsilon^2*(5*(epsilon*r).^2+30*(epsilon*dy).^2-4*epsilon*r-1).*max(1-epsilon*r,0).^4;   % Wendland C4
%dyyrbf = @(epsilon,r,dy) 22*epsilon^2*max(1-epsilon*r,0).^6.*(16*epsilon^3*(r.^2+9*dy.^2).*r+3*epsilon^2*(8*dy.^2-3*r.^2)-6*epsilon*r-1);   % Wendland C6
% Laplacian
Lrbf = @(epsilon,r) 4*epsilon^2*exp(-(epsilon*r).^2).*((epsilon*r).^2-1);    % Gaussian
%Lrbf = @(epsilon,r) epsilon^2*((epsilon*r).^2-2)./(1+(epsilon*r).^2).^(5/2);   % IMQ
%Lrbf = @(epsilon,r) epsilon^2*((epsilon*r).^2-2*epsilon*r-2).*exp(-epsilon*r);   % Matern quadratic 
%Lrbf = @(epsilon,r) epsilon^2*exp(-epsilon*r).*((epsilon*r).^3-(epsilon*r).^2-6*epsilon*r-6);   % Matern cubic
%Lrbf = @(epsilon,r) epsilon^2*(2+(epsilon*r).^2)./(1+(epsilon*r).^2).^(3/2);   % MQ
%Lrbf = @(epsilon,r) 5*epsilon^2*(5*(epsilon*r).^2+2).*sqrt(1+(epsilon*r).^2);  % generalized MQ
%Lrbf = @(epsilon,r) 25*epsilon^5*r.^3;   % quintic
%Lrbf = @(epsilon,r) -4*epsilon^2*exp(-(epsilon*r).^2).*((epsilon*r).^4-5*(epsilon*r).^2+3);   % linear Laguerre-Gaussian
%Lrbf = @(epsilon,r) 112*epsilon^2*max(1-epsilon*r,0).^4.*(20*(epsilon*r).^2-4*epsilon*r-1);   % Wendland C4
%Lrbf = @(epsilon,r) 44*epsilon^2*max(1-epsilon*r,0).^6.*(88*(epsilon*r).^3+3*(epsilon*r).^2-6*epsilon*r-1);   % Wendland C6
% Double Laplacian
L2rbf = @(epsilon,r) 16*epsilon^4*(2-4*(epsilon*r).^2+(epsilon*r).^4).*exp(-(epsilon*r).^2);    % Gaussian
%L2rbf = @(epsilon,r) 3*epsilon^4*(3*(epsilon*r).^4-24*(epsilon*r).^2+8)./(1+(epsilon*r).^2).^(9/2);   % IMQ
%L2rbf = @(epsilon,r) epsilon^4*((epsilon*r).^2-7*epsilon*r+8).*exp(-epsilon*r);    %Matern quadratic
%L2rbf = @(epsilon,r) epsilon^4*((epsilon*r).^3-8*(epsilon*r).^2+8*epsilon*r+8).*exp(-epsilon*r);   Matern cubic
%L2rbf = @(epsilon,r) epsilon^4*((epsilon*r).^4+8*(epsilon*r).^2-8)./(1+(epsilon*r).^2).^(7/2);   % MQ
%L2rbf = @(epsilon,r) 15*epsilon^4*(15*(epsilon*r).^4+24*(epsilon*r).^2+8)./(1+(epsilon*r)).^(3/2);   % generalized MQ
%L2rbf = @(epsilon,r) 225*epsilon^5*r;   % quintic
%L2rbf = @(epsilon,r) -16*epsilon^4*exp(-(epsilon*r).^2).*((epsilon*r).^6-10*(epsilon*r).^4+22*(epsilon*r).^2-8);   % linear Laguerre-Gaussian
%L2rbf = @(epsilon,r) 6720*epsilon^4*max(1-epsilon*r,0).^2.*(12*(epsilon*r).^2-11*epsilon*r+2);   % Wendland C4
%L2rbf = @(epsilon,r) 1056*epsilon^4*max(1-epsilon*r,0).^4.*(297*(epsilon*r).^3-212*(epsilon*r).^2+16*epsilon*r+4);   % Wendland C6
% SPARSE derivatives
%dxrbf = @(epsilon,r,dx) -56*dx*epsilon^2.*r.^5.*(6*spones(r)-5*r);   % Wendland C4
%dxrbf = @(epsilon,r,dx) -22*dx*epsilon^2.*r.^7.*(24*spones(r)-39*r+16*r.^2);   % Wendland C6
%dyrbf = @(epsilon,r,dy) -56*dy*epsilon^2.*r.^5.*(6*spones(r)-5*r);   % Wendland C4
%dyrbf = @(epsilon,r,dy) -22*dy*epsilon^2.*r.^7.*(24*spones(r)-39*r+16*r.^2);   % Wendland C6
%dxxrbf = @(epsilon,r,dx) 56*epsilon^2*r.^4.*(30*(epsilon*dx).^2-6*r+5*r.^2);   % Wendland C4
%dxxrbf = @(epsilon,r,dx) -22*epsilon^2*r.^6.*(-168*(epsilon*dx).^2+24*r-39*r.^2+16*r.^3+144*(epsilon*dx).^2.*r);   % Wendland C6
%dxyrbf = @(epsilon,r,dx,dy) 1680*epsilon^4*dx.*dy.*r.^4;   % Wendland C4
%dxyrbf = @(epsilon,r,dx,dy) 528*epsilon^4*dx.*dy.*r.^6.*(7*spones(r)-6*r);   % Wendland C6
%dyyrbf = @(epsilon,r,dy) 56*epsilon^2*r.^4.*(30*(epsilon*dy).^2-6*r+5*r.^2);   % Wendland C4
%dyyrbf = @(epsilon,r,dy) -22*epsilon^2*r.^6.*(-168*(epsilon*dy).^2+24*r-39*r.^2+16*r.^3+144*(epsilon*dy).^2.*r);   % Wendland C6
%Lrbf = @(epsilon,r) 112*epsilon^2*r.^4.*(15*spones(r)-36*r+20*r^2);   % Wendland C4
%Lrbf = @(epsilon,r) 44*epsilon^2*r.^6.*(84*spones(r)-264*r+267*r.^2-88*r.^3);   % Wendland C6
%L2rbf = @(epsilon,r) 6720*epsilon^4*r.^2.*(3*spones(r)-13*r+12*r.^2);   % Wendland C4
%L2rbf = @(epsilon,r) 1056*epsilon^4*r.^4.*(105*spones(r)-483*r+679*r.^2-297*r.^3);   % Wendland C6
