% p36.m - Laplace eq. on [-1,1]x[-1,1] with nonzero BCs
% Adapted to use Laplacian computed directly from RBFs

%rbf = @(e,r) exp(-(e*r).^2);     % Gaussian RBF
%Lrbf = @(e,r) 4*e^2*exp(-(e*r).^2).*((e*r).^2-1);    % Gaussian
rbf = @(e,r) exp(-e*r).*(15+15*e*r+6*(e*r).^2+(e*r).^3); % cubic Matern 
Lrbf = @(e,r) e^2*exp(-e*r).*((e*r).^3-(e*r).^2-6*e*r-6); % cubic Matern 

% Set up grids and find Laplacian
N = 24;
[L,x,y] = LRBF(N,rbf,Lrbf);

[xx,yy] = meshgrid(x,y);
xx = xx(:); yy = yy(:);       % stretch 2D grids to 1D vectors
  
% Impose boundary conditions by replacing appropriate rows of L:
b = find(abs(xx)==1 | abs(yy)==1);            % boundary pts
L(b,:) = zeros(4*N,(N+1)^2); L(b,b) = eye(4*N);
rhs = zeros((N+1)^2,1);
rhs(b) = (yy(b)==1).*(xx(b)<0).*sin(pi*xx(b)).^4 + ...
         .2*(xx(b)==1).*sin(3*pi*yy(b));

u = L\rhs; 

uu = reshape(u,N+1,N+1);
[xx,yy] = meshgrid(x,y);
[xxx,yyy] = meshgrid(-1:.04:1,-1:.04:1);
uuu = interp2(xx,yy,uu,xxx,yyy,'cubic');
surf(xxx,yyy,uuu), colormap('default');
axis([-1 1 -1 1 -.2 1]), view(-20,45)
text(0,.8,.4,sprintf('u(0,0) = %12.10f',uu(N/2+1,N/2+1)))
