% rbf = buhmann(epsilon,r)
%
% Defines one of Buhmann's compactly supported RBFs (C^2, SPD in R^3)

function rbf = buhmann_sparse(epsilon,r)

[m,n] = size(r);
rbf = zeros(m,n);
for i=1:m
    for j=1:n
        if (r(i,j) == 0)
            rbf(i,j) = 1;
        else
            if (r(i,j) <= 1)
                q = (r(i,j));
                rbf(i,j) = 12*(1-q)^4*log(1-q)-18+77*q-118*q^2+81*q^3-21*q^4;
            else
                rbf(i,j) = 0;
            end
        end
    end
end
