% rbf = buhmann(epsilon,r)
%
% Defines one of Buhmann's compactly supported RBFs (C^2, SPD in R^3)

function rbf = buhmann(epsilon,r)

[m,n] = size(r);
rbf = zeros(m,n);
for i=1:m
    for j=1:n
        if (r(i,j) == 0)
            rbf(i,j) = 1;
        else
            if (r(i,j) <= 1)
                q = (epsilon*r(i,j));
                rbf(i,j) = 12*q^4*log(q)-21*q^4+32*q^3-12*q^2+1;
            else
                rbf(i,j) = 0;
            end
        end
    end
end
