function [maxerr, rms_err, N] = ShepardCS_sD(N, s, gridtype)
% function [maxerr, rms_err, N] = ShepardCS_sD(N, s, gridtype)
% Computes Shepard approximation for arbitrary
% space dimensions s using sparse matrices
% Inputs:
% s: space dimension
% N: number of interpolation points
% gridtype: Type of data points: 'c'=Chebyshev, 'f'=fence(rank-1 lattice),
% 'h'=Halton, 'l'=latin hypercube, 'n'=random normal, 'r'=random uniform,
% 's'=Sobol, 'u'=uniform   
% Outputs:
% maxerr: maximum error on set of M (set below) random points 
% rms_err: RMS error on set of M (set below) random points 
% N: actual number of data points used (could be smaller for 'c' and 'u'
% types)
% Calls on: rbf_definition, testfunctionsD, DistanceMatrixCSRBF

% Number of evaluation points for error computation
M = 500;      % to create evaluation grid in unit cube

% The RBF is defined in the function rbf_definition 
% (separate file rbf_definition has to be edited to get desired RBF, 
% however, this file can be accessed by all programs)
global rbf
rbf_definition;

ep = nthroot(N,s); % Scale parameter for basis function

%%%%%%%%%%%%%%%%%% Code below this line need not be changed %%%%%%%%%%%%%%%%

[dsites, N] = CreatePoints(N,s,gridtype);
% Let centers coincide with data sites
ctrs = dsites;

% Create vector of function (data) values
f = testfunctionsD(dsites);

% Create evaluation locations in the unit cube
epoints = CreatePoints(M,s,'r');

% Compute evaluation matrix, i.e.,
% matrix of values of generating functions
DM_eval = DistanceMatrixCSRBF(epoints,ctrs,ep);
EM = rbf(ep,DM_eval);
% Shepard scaling
EM = spdiags(1./(EM*ones(N,1)),0,M,M)*EM;
% Compute quasi-interpolant
Pf = EM*f;
% Compute exact solution, i.e.,
% evaluate test function on evaluation points
exact = testfunctionsD(epoints);
% Compute errors on evaluation grid
maxerr = norm(Pf-exact,inf);
rms_err = norm(Pf-exact)/sqrt(M);
fprintf('RMS error:     %e\n', rms_err)
fprintf('Maximum error: %e\n', maxerr)
