function [x,count] = Riley_Residuals(A,b,mu,ErrLimit,Maxiters)
    C = A + mu*eye(size(A));
    L = chol(C,'lower');
    z = L\b;
    x = L'\z;
    err = 1;
    count = 1;
    while (err > ErrLimit && count <= Maxiters)
        z = L\(b - A*x);
        xnew = x + L'\z;
        err = norm((xnew(:,1) - x(:,1))./x(:,1))^2; 
        count = count+1;
        x = xnew;
    end
    disp(sprintf('Iterations: %d',count-1))
end
