%%% =================================================
%% Function for solving system of linear equations 
%% Ax = b, using the Riley Algorithm.
%%
%% function usage :
%% [x,count] = Riley(A,b,mu,MaxErr,Iters) ;
%%
%% Input : 
%%   A = Square matrix of size (N x N).
%%   b = RHS vector of size (N x 1).
%%  mu = Ridge parameter. Scalar.
%%  MaxErr = Relative error tolerance.
%%   Iters = Upper limit on the number of iterations
%%           to be performed.
%%
%%  Output :
%%   x = Solution vector of size (N x 1).
%%
%% Version 2a. June 9, 2008.
%%  Original code : Mokhasi and Fasshauer.
%%% =================================================

function [x,count] = Riley(A,b,mu,MaxErr,Iters)
    C = A + mu*eye(size(A));
    L = chol(C,'lower');
    z = L\b;
    y = L'\z;
    x = y;
    err=1; count=1;
    while (err > MaxErr && count <= Iters)
        z = mu*(L\y);
        y = L'\z;
        x = x + y;
        err = norm(y(:,1))^2; 
        count=count+1;
    end
%    disp(sprintf('Iterations: %d',count-1))
end
