function [maxerr, rms_err, N, epsilon] = RBFInterp_sDLOOCV(N, s, gridtype)
% function [maxerr, rms_err, epsilon] = RBFInterp_sDLOOCV(N, s, gridtype)
% Computes sD RBF interpolation with LOOCV
% Inputs:
% s: space dimension
% N: number of interpolation points
% gridtype: Type of data points: 'c'=Chebyshev, 'f'=fence(rank-1 lattice),
% 'h'=Halton, 'l'=latin hypercube, 'n'=random normal, 'r'=random uniform,
% 's'=Sobol, 'u'=uniform   
% Outputs:
% maxerr: maximum error on set of M (set below) random points 
% rms_err: RMS error on set of M (set below) random points 
% N: actual number of data points used (could be smaller for 'c' and 'u'
% types)
% Calls on: rbf_definition, testfunctionsD, DistanceMatrix, CostEps

%%%%%%%%%%%%%%%%%% Editable Section %%%%%%%%%%%%%%%%%%%%

% Number of evaluation points for error computation
M = 500;      % to create evaluation grid in unit cube

% The RBF is defined in the function rbf_definition 
% (separate file rbf_definition has to be edited to get desired RBF, 
% however, this file can be accessed by all programs)
global rbf;  rbf_definition;  mine = 0; maxe = 20;

%%%%%%%%%%%%%%%%%% Code below this line need not be changed %%%%%%%%%%%%%%%%

% Create evaluation locations in the unit cube
evalpoints = CreatePoints(M,s,'r');
% Compute exact solution, i.e., evaluate test function on evaluation points
exact = testfunctionsD(evalpoints);

[datasites, N] = CreatePoints(N,s,gridtype);
% Let centers coincide with data sites
centers = datasites;

% Evaluate the test function at the data points
rhs = testfunctionsD(datasites);

% Now we find the RBF interpolant (this should not require any changes)
% Compute the distance matrix between the data sites and centers
DM_data = DistanceMatrix(datasites,centers);
% Compute the distance matrix between the evaluation points and centers
DM_eval = DistanceMatrix(evalpoints,centers);

epsilon = fminbnd(@(epsilon) CostEps(epsilon,DM_data,rbf,rhs),mine,maxe);

% Compute interpolation matrix
IM = rbf(epsilon,DM_data);
coef = IM\rhs;

% Compute evaluation matrix
EM = rbf(epsilon,DM_eval);
% Compute RBF interpolant (evaluation matrix * solution of interpolation system)
Pf = EM * coef;

% Compute maximum error on evaluation grid
maxerr = max(abs(Pf - exact));
rms_err = norm(Pf-exact)/sqrt(M);


