% ploterror2D(xe,ye,Pf,exact,maxerr,neval,fview,caption)
%
% Generates plot of abs error for surface Pf, i.e., abs(Pf-exact)
% fview defines the view, and the caption is displayed.
%

function ploterror2D(xe,ye,Pf,exact,maxerr,neval,fview,caption)

% Plot maximum error
figure
errorplot = surf(xe,ye,reshape(abs(Pf-exact),neval,neval));
set(errorplot,'FaceColor','interp','EdgeColor','none')
set(gca,'Fontsize',14)
xlabel('x','FontSize',14);
ylabel('y','FontSize',14);
zlabel('z','FontSize',14,'Rotation',0);
[cmin cmax] = caxis;
%caxis([cmin-.2*maxerr cmax+.2*maxerr])
%colormap hot
caxis([cmin-.25*maxerr cmax])
view(fview);
colormap hsv
vcb = colorbar('vert');
ylim(vcb,[0 maxerr])
set(get(vcb,'YLabel'),'String','Error','FontSize',14)
title(caption)


