% DM = DistanceMatrixA(dsites,ctrs)
% Forms the distance matrix of two sets of points in R^s,
% i.e., DM(i,j) = || datasite_i - center_j ||_2.
% Input
%   dsites: Mxs matrix representing a set of M data sites in R^s
%              (i.e., each row contains one s-dimensional point)
%   ctrs:   Nxs matrix representing a set of N centers in R^s
%              (one center per row)
% Output
%   DM:     MxN matrix whose i,j position contains the Euclidean
%              distance between the i-th data site and j-th center
  function DM = DistanceMatrixA(dsites,ctrs)
  [M,s] = size(dsites); [N,s] = size(ctrs);
  DM = zeros(M,N);
  % Accumulate sum of squares of coordinate differences
  for d=1:s
     %%% Uses less memory
     DM = DM + (repmat(dsites(:,d),1,N)-repmat(ctrs(:,d)',M,1)).^2;
  end
  DM = sqrt(DM);
