% ceps = CostEpsRiley(ep,rbf,r,rhs,maxerr,iter)
% Implements cost function for optimization of shape parameter 
% via Rippa's LOOCV algorithm 
% Uses Riley's algorithm to solve linear systems
% Example of usage in LOOCV2Dmin.m
  function ceps = CostEpsRiley(ep,r,rbf,rhs,maxerr,iter)
  A = rbf(ep,r);
  mu = 1e-11;
  D = Riley(A,[rhs eye(size(A))],mu,maxerr,iter);  % contains solution of Ax=b and A^-1
  errorvector = D(:,1)./diag(D(:,2:end));
  ceps = norm(errorvector);
