% ceg = CostEpsGamma(ep,gamma,r,rbf,rhs,ep)
% Implements cost function for optimization of shape parameter epsilon or 
% smoothing parameter gamma via Rippa's LOOCV algorithm
function ceg = CostEpsGamma(ep,gamma,r,rbf,rhs,ep)
  A = rbf(ep,r);
  A = A + eye(size(A))/gamma;
  invA = pinv(A);
  errorvector = (invA*rhs)./diag(invA);
  ceg = norm(errorvector);