% ceps = CostEps(ep,rbf,r,rhs)
% Implements cost function for optimization of shape parameter 
% via Rippa's LOOCV algorithm
% Example of usage in LOOCV2Dmin.m
  function ceps = CostEps(ep,r,rbf,rhs)
  A = rbf(ep,r);
  invA = pinv(A);
  errorvector = (invA*rhs)./diag(invA);
  ceps = norm(errorvector);
