% -----------------------------------------------------------------------------
% LaTeX class for the journal 
% Dolomites Research Notes on Approximation
% 
% Kai Hormann <kai.hormann@usi.ch>
% -----------------------------------------------------------------------------
%%
%% This file is 'drna.cls'
%% 
%% It may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{drna}[2014/01/10 v. 1.0 DRNA class]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}} 
\ProcessOptions\relax
\LoadClass{article}

%%
%% font settings
%%
\RequirePackage[T1]{fontenc}
\RequirePackage[latin1]{inputenc}
\RequirePackage[charter,cal=cmcal]{mathdesign}
\renewcommand{\sfdefault}{uop}

%%
%% page settings
%%
\RequirePackage[a4paper,scale=0.8]{geometry}

%%
%% header and footer settings
%%
\RequirePackage{fancyhdr}
\setlength{\headheight}{29pt}
\setlength{\footskip}{39pt}
\pagestyle{fancyplain}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{1pt}
\lhead{\raisebox{-8pt}{\includegraphics[width=\textwidth]{heading}}}
\rhead{\fancyplain{}{\thepage}}
\lfoot{Dolomites Research Notes on Approximation}
\cfoot{}
\rfoot{ISSN 2035-6803}

%%
%% language settings
%%
\RequirePackage[british]{babel}

%%
%% captions settings
%%
\RequirePackage[small,bf]{caption}

%%
%% hyperref settings
%%
\RequirePackage[colorlinks,linkcolor=blue,citecolor=blue,urlcolor=blue]{hyperref}
\hypersetup{pdfpagelayout=SinglePage,pdfdisplaydoctitle}

%%
%% graphics settings
%%
\RequirePackage{graphicx}

%%
%% tweaking the footnotes
%%
\RequirePackage[hang,flushmargin]{footmisc} 

%%
%% referring to the last page number
%%
\RequirePackage{lastpage}

%%
%% optimized typography
%%
\RequirePackage{ifpdf}
\ifpdf
  \RequirePackage[protrusion=true,expansion=true]{microtype}
\fi

%%
%% new commands to pass authors and affiliations
%%
\def\addtok#1#2{\global#1\expandafter{\the#1#2}}
\newcounter{n@authors}
\newtoks\@authors
\newtoks\@pdfauthors
\newtoks\@shortauthors
\renewcommand{\author}[3]{%
  \stepcounter{n@authors}%
  \ifnum \then@authors > 1 \addtok\@authors{~$\cdot$~} \addtok\@pdfauthors{, } \addtok\@shortauthors{~$\cdot$~} \fi%
  \addtok\@authors{#2~#1$^{\,#3}$}%
  \addtok\@pdfauthors{#2~#1}%
  \addtok\@shortauthors{#1}%
}
\newcounter{n@affiliations}
\newtoks\@affiliations
\newcommand{\affiliation}[2]{%
  \stepcounter{n@affiliations}%
  \ifnum \then@affiliations > 1 \addtok\@affiliations{\newline} \fi%
  \addtok\@affiliations{$^{#1}$#2}%
}

%%
%% title page
%%
\newtoks\@volume
\newcounter{pubyear}
\newtoks\@firstpage

\newcommand{\volume}[1]{\global\@volume{#1}\setcounter{pubyear}{#1}\addtocounter{pubyear}{2007}}
\newcommand{\firstpage}[1]{\setcounter{page}{#1}}

\renewcommand{\maketitle}{ 
  \newpage
  \null
  \noindent{\begin{picture}(0,0)\put(0,0){\makebox[0pt][c]{\raisebox{10pt}{\includegraphics{header}}}}\end{picture}}\\[-2ex]
  {\raggedleft Volume~\the\@volume~$\cdot$~\arabic{pubyear}~$\cdot$~Pages~\thepage--\pageref*{LastPage}\par}
% {\raggedleft Lecture notes\par}
  \vskip1.5em%
  \hrule%
  \vskip2.5em%
  {\noindent\huge\centering\@title\par}%
  \vskip1.5em%
  {\noindent\large\centering\the\@authors\par}%
  {\let\thefootnote\relax\footnote{\noindent\the\@affiliations}\setcounter{footnote}{0}}
  \vskip0.5em%
  \thispagestyle{empty}\enlargethispage{30pt}%
  \chead{\the\@shortauthors}
  \hypersetup{pdftitle=\@title}
  \hypersetup{pdfauthor=\the\@pdfauthors}
  \hypersetup{pdfsubject={Dolomites Research Notes on Approximation, Volume \the\@volume}}
  
  \vskip 0.2in
\begin{center} {\it Communicated by Stefano De Marchi} \end{center}
\vskip 0.2in
}

%%
%% abstract 
%%
\renewenvironment{abstract}{
  \centering\begin{minipage}[t]{.8\textwidth}
  \hrule\vskip1em\noindent%
  \centering\begin{minipage}[t]{.9\textwidth}
  \small\noindent%
  {\centering\bfseries\abstractname\vskip.4em}%
  \noindent\ignorespaces%
}{
  \end{minipage}\par%
  \vskip1em\hrule\vskip1.5em%
  \end{minipage}\par%
  \vskip3em
}

%%
%% bibliography settings
%%
\renewenvironment{thebibliography}[1]
  {\subsection*{\refname}\small%
  \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
  \list{\@biblabel{\@arabic\c@enumiv}}%
       {\itemsep 2pt plus 1pt minus 1pt%
        \parsep 1pt%
        \settowidth\labelwidth{\@biblabel{#1}}%
        \leftmargin\labelwidth
        \advance\leftmargin\labelsep
        \@openbib@code
        \usecounter{enumiv}%
        \let\p@enumiv\@empty
        \renewcommand\theenumiv{\@arabic\c@enumiv}}%
  \sloppy
  \clubpenalty4000
  \@clubpenalty \clubpenalty
  \widowpenalty4000%
  \sfcode`\.\@m}
  {\def\@noitemerr
   {\@latex@warning{Empty `thebibliography' environment}}%
  \endlist}

%%
%% font sizes and vertical spacings
%%
\setlength\parindent{1.5em}
\setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 2\p@ \@plus\p@ \@minus\p@
            \topsep 4\p@ \@plus\p@ \@minus2\p@
            \itemsep2\p@ \@plus\p@ \@minus\p@}
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \parsep}
\def\@listiiii {\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}

\renewcommand\normalsize{%
    \@setfontsize\normalsize\@ixpt{12}%
    \abovedisplayskip 7\p@ \@plus3\p@ \@minus4\p@
    \abovedisplayshortskip \z@ \@plus3\p@
    \belowdisplayshortskip 5\p@ \@plus3\p@ \@minus3\p@
    \belowdisplayskip \abovedisplayskip
    \let\@listi\@listI}
\normalsize
\renewcommand\small{%
    \@setfontsize\small\@viiipt{11}%
    \abovedisplayskip 6\p@ \@plus3\p@ \@minus4\p@
    \abovedisplayshortskip \z@ \@plus2\p@
    \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
    \def\@listi{\leftmargin\leftmargini
                \topsep 4\p@ \@plus2\p@ \@minus2\p@
                \parsep 2\p@ \@plus\p@ \@minus\p@
                \itemsep \parsep}%
    \belowdisplayskip \abovedisplayskip}
\renewcommand\footnotesize{%
    \@setfontsize\footnotesize\@viipt\@viiipt
    \abovedisplayskip 5\p@ \@plus3\p@ \@minus4\p@
    \abovedisplayshortskip \z@ \@plus\p@
    \belowdisplayshortskip 3\p@ \@plus\p@ \@minus\p@
    \def\@listi{\leftmargin\leftmargini
                \topsep 3\p@ \@plus\p@ \@minus\p@
                \parsep 2\p@ \@plus\p@ \@minus\p@
                \itemsep \parsep}%
    \belowdisplayskip \abovedisplayskip}
\renewcommand\scriptsize{\@setfontsize\scriptsize\@vipt\@viipt}
\renewcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\renewcommand\large{\@setfontsize\large\@xpt\@xiipt}
\renewcommand\Large{\@setfontsize\Large\@xiipt{14}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xivpt{18}}
\renewcommand\huge{\@setfontsize\huge\@xviipt{22}}
\renewcommand\Huge{\@setfontsize\Huge\@xxpt{25}}

\renewcommand\section{\@startsection {section}{1}{\z@}%
  {-2.5ex \@plus -1ex \@minus -.2ex}%
  {1.3ex \@plus.2ex}%
  {\normalfont\Large\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
  {-2.25ex\@plus -1ex \@minus -.2ex}%
  {1ex \@plus .2ex}%
  {\normalfont\large\bfseries}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {-2.25ex\@plus -1ex \@minus -.2ex}%
  {1ex \@plus .2ex}%
  {\normalfont\normalsize\bfseries}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
  {2.25ex \@plus1ex \@minus.2ex}%
  {-1em}%
  {\normalfont\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
  {2.25ex \@plus1ex \@minus .2ex}%
  {-1em}%
  {\normalfont\normalsize\bfseries}}

%%
%% other useful packages
%%
\RequirePackage{amsmath,amsthm}
\RequirePackage{enumerate}

%%
%% Theorems, Lemmas, etc.
%%
\theoremstyle{plain}
\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{proposition}[theorem]{Proposition}

\theoremstyle{definition}
\newtheorem{definition}{Definition}[section]
\newtheorem{example}{Example}[section]

\theoremstyle{remark}
\newtheorem{remark}{Remark}

\def\NN{\mathbb{N}}
\def\ZZ{\mathbb{Z}}
\def\QQ{\mathbb{Q}}
\def\RR{\mathbb{R}}
\def\CC{\mathbb{C}}

\providecommand{\abs}[1]{\lvert{#1}\rvert}
\providecommand{\norm}[1]{\lVert{#1}\rVert}
